<%*
// Retrieve the "Note type" from the front matter
const noteType = tp.frontmatter['Note type'];

// Common variables
const dv = this.app.plugins.plugins["dataview"].api;
const curr = tp.config.target_file;
const dvCurr = dv.page(curr.path);
const baseFolder = app.vault.getAbstractFileByPath(dvCurr.file.folder);
const relatedProjects = tp.frontmatter["Related projects"];
const formattedRelatedProjects = Array.isArray(relatedProjects) 
    ? relatedProjects.map(project => "- \"" + project + "\"").join("\n")
    : relatedProjects ? "- \"" + relatedProjects + "\"" : ""; // Handle the case where it's not an array
const relatedTasks = tp.frontmatter["Related tasks"];
const formattedRelatedTasks = Array.isArray(relatedTasks) 
    ? relatedTasks.map(task => "- \"" + task + "\"").join("\n")
    : relatedTasks ? "- \"" + relatedTasks + "\"" : ""; // Handle the case where it's not an array
const relatedMeetingNotes = tp.frontmatter["Related meeting notes"]; 
const formattedRelatedMeetingNotes = Array.isArray(relatedMeetingNotes) 
	? relatedMeetingNotes.map(meeting => "- \"" + meeting + "\"").join("\n")
	: relatedMeetingNotes ? "- \"" + relatedMeetingNotes + "\"" : ""; // Handle the case where it's not an array
const relatedPeople = tp.frontmatter["Related people"];
const formattedRelatedPeople = Array.isArray(relatedPeople)
    ? relatedPeople.map(person => "- \"" + person + "\"").join("\n")
    : relatedPeople ? "- \"" + relatedPeople + "\"" : ""; // Handle the case where it's not an array
const relatedResources = tp.frontmatter["Related resources"];
const formattedRelatedResources = Array.isArray(relatedResources)
    ? relatedResources.map(resource => "- \"" + resource + "\"").join("\n")
    : relatedResources ? "- \"" + relatedResources + "\"" : ""; // Handle the case where it's not an array
const relatedReferences = tp.frontmatter["Related references"];
const formattedRelatedReferences = Array.isArray(relatedReferences)
    ? relatedReferences.map(reference => "- \"" + reference + "\"").join("\n")
    : relatedReferences ? "- \"" + relatedReferences + "\"" : ""; // Handle the case where it's not an array
const relatedZettels = tp.frontmatter["Related zettels"];
const formattedRelatedZettels = Array.isArray(relatedZettels)
    ? relatedZettels.map(zettel => "- \"" + zettel + "\"").join("\n")
    : relatedZettels ? "- \"" + relatedZettels + "\"" : ""; // Handle the case where it's not an array
const date = tp.date.now("YYYY-MM-DD"); // Get current date formatted as YYYY-MM-DD

const newFile = await tp.system.prompt("New file name");
if (!newFile) return; // Exit if no file name is provided

let content = "";

// Conditional logic to determine which script to execute based on the note type
switch(noteType) {
    case 'Project':
        content = 
`---
Note type: MoC
tags:
  - "#MoC"
Related areas: 
Related projects:
- "[[${tp.file.title}]]"
${formattedRelatedProjects}
Related tasks:
Related MoCs:
Related references:
Related zettels:
Related meeting notes:
${formattedRelatedMeetingNotes}
Related resources:
Related people:
aliases:
Creation date: "${date}"
Last modified: ${date}
---
`;
        break;
    case 'Task':
        content = 
`---
Note type: MoC
tags:
  - "#MoC"
Related areas: 
Related projects:
${formattedRelatedProjects}
Related tasks:
- "[[${tp.file.title}]]"
Related MoCs:
Related references:
Related zettels:
Related meeting notes:
${formattedRelatedMeetingNotes}
Related resources:
Related people:
aliases:
Creation date: "${date}"
Last modified: ${date}
---
`;
        break;
    case 'Meeting':
    case 'Resource':
        content = 
`---
Note type: MoC
tags:
  - "#MoC"
Related areas: 
Related projects:
${formattedRelatedProjects}
Related tasks:
Related MoCs:
Related references:
Related zettels:
Related meeting notes:
${formattedRelatedMeetingNotes}
Related resources:
- "[[${tp.file.title}]]"
Related people:
aliases:
Creation date: "${date}"
Last modified: ${date}
---
`;
        break;
    case 'Person':
        content = 
`---
Note type: MoC
tags:
  - "#MoC"
Related areas: 
Related projects:
${formattedRelatedProjects}
Related tasks:
Related MoCs:
Related references:
Related zettels:
Related meeting notes:
${formattedRelatedMeetingNotes}
Related resources:
Related people:
- "[[${tp.file.title}]]"
aliases:
Creation date: "${date}"
Last modified: ${date}
---
`;
        break;
    case 'Area':
        content = 
`---
Note type: MoC
tags:
  - "#MoC"
Related areas: 
Related projects:
${formattedRelatedProjects}
Related tasks:
Related MoCs:
Related references:
Related zettels:
Related meeting notes:
${formattedRelatedMeetingNotes}
Related resources:
Related people:
aliases:
Creation date: "${date}"
Last modified: ${date}
---
`;
        break;
    case 'Reference':
        content = 
`---
Note type: MoC
tags:
  - "#MoC"
Related areas: 
Related projects:
${formattedRelatedProjects}
Related tasks:
Related MoCs:
Related references:
- "[[${tp.file.title}]]"
Related zettels:
Related meeting notes:
${formattedRelatedMeetingNotes}
Related resources:
Related people:
aliases:
Creation date: "${date}"
Last modified: ${date}
---
`;
        break;
    case 'Zettel':
    case 'MoC':
        content = 
`---
Note type: MoC
tags:
  - "#MoC"
Related areas: 
Related projects:
${formattedRelatedProjects}
Related tasks:
Related MoCs:
Related references:
${formattedRelatedReferences}
Related zettels:
- "[[${tp.file.title}]]"
Related meeting notes:
${formattedRelatedMeetingNotes}
Related resources:
${formattedRelatedResources}
Related people:
aliases:
Creation date: "${date}"
Last modified: ${date}
---
`;
        break;
    default:
        tp.ui.alert('No applicable script for this note type.');
        return;
}

// Create the new file
await tp.file.create_new(content, newFile, true, baseFolder);
%>